/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.graphics;

import com.ibm.hwmca.fw.servlet.graphics.GraphicsHelper;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GraphicsServlet
extends HttpServlet {
    public static final String TRACE_MASKT = "XGFXSRVT";
    public static final String TRACE_MASKF = "XGFXSRVF";
    public static final String TRACE_MASKD = "XGFXSRVD";
    public static final String SERVLET_NAME = "/hmc/graphics";
    public static final String CHART_TYPE = "chartType";
    public static final String TYPE_PIE = "typePie";
    private static Map graphicsFactories = new HashMap();

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        Trace.trace(TRACE_MASKT, "-> " + ((Object)((Object)this)).getClass().getName() + ".doGet()");
        String type = request.getParameter(CHART_TYPE);
        Object o = graphicsFactories.get(type);
        if (o != null) {
            if (o instanceof String) {
                Object factoryObj = null;
                try {
                    factoryObj = Class.forName((String)o).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Trace.trace(TRACE_MASKF, "instantiated factory object for '" + type + "' : " + factoryObj);
                graphicsFactories.put(type, factoryObj);
                if (factoryObj instanceof GraphicsHelper) {
                    ((GraphicsHelper)factoryObj).handleRequest(request, response);
                }
            } else if (o instanceof GraphicsHelper) {
                ((GraphicsHelper)o).handleRequest(request, response);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    static {
        graphicsFactories.put(TYPE_PIE, "com.ibm.hwmca.fw.servlet.graphics.PieChart");
    }
}

